#pragma once
#include <qopenglwidget.h>

#include <qopenglshaderprogram.h>
#include <QMouseEvent>
#include <qmenu.h>

#include "model.h"
#include "camera.h"
#include "workPlane.h"
#include "viewCube.h"
#include "LineDrawer.h"

class GLView : public QOpenGLWidget, QOpenGLFunctions_4_5_Core
{
	Q_OBJECT
public:
	explicit GLView(QWidget* parent = nullptr);
	~GLView();

	void beginDrawLines();
	void clearAllLines();
	void undoLastLine();
	void selectLine();


protected:
	virtual void initializeGL();
	virtual void resizeGL(int w,int h);
	virtual void paintGL();
	virtual bool event(QEvent* e);

	void initWorkPlane();

	QVector3D screenToWorld_3D_PointSnap(const QPoint& pos);
	QVector3D screenToWorldRawRay(const QPoint& pos);
	float rayLineDistance(const QPoint& mousePos, const QVector3D& rayOrigin, const QVector3D& rayDir, const QVector3D& lineStart, const QVector3D& lineEnd);
	bool checkLineHit(const QPoint& mousePos);
	bool getRayPlaneIntersection(const QVector3D& rayOrigin, const QVector3D& rayDir, const QVector3D& planeOrigin, const QVector3D& planeNormal, QVector3D& outIntersection);

private:
	void initShader(QOpenGLShaderProgram& shader, const QString& vertexFile, const QString& fragFile);

private:
	Model* m_model{ nullptr };
	Camera m_camera = Camera(this, QVector3D(0.0f, 0.0f, 5.0f));

	//mvp
	QMatrix4x4 m_modelMat;//ԶΪλ
	QMatrix4x4 m_viewMat;
	QMatrix4x4 m_projectionMat;

	//ɫ
	QOpenGLShaderProgram m_lightShader;
	QOpenGLShaderProgram m_viewCubeShader;
	QOpenGLShaderProgram m_drawLineShader;

	//ƽ
	WorkPlane* m_workPlane{ nullptr };

	//ͼ
	ViewCube* m_viewCube{ nullptr };

	QMatrix4x4 m_modelCube;      
	QMatrix4x4 m_viewMatNoTrans;
	QMatrix4x4 m_projection4ViewCube;
	QMatrix4x4 m_finalProjection;

	//ֱ߻
	LineDrawer m_lineDrawer;

	bool b_drawLineState = false;

	// ƽֱƽҳӽǣ
	QVector3D m_drawPlaneOrigin;     // ƽԭ㣨ֱ㣩
	QVector3D m_drawPlaneNormal;     // ƽ淨ֱƽ棬ӽǣ
	bool m_enableDrawPlane = true;   // ǷƽԼ

	bool b_selectLineState = false;

	QMenu* m_onSelectMenu = nullptr;
	QAction* m_action_deleteSelecedLine = nullptr;

signals:

};