#include "MainWindow.h"

MainWindow::MainWindow(QWidget* parent)
    : QMainWindow(parent)
{
    ui.setupUi(this);
    connect(ui.action_drawLines, &QAction::triggered, this, [=]()
    {
        ui.openGLWidget->beginDrawLines();
    });

    connect(ui.action_selectLine,& QAction::triggered, this, [=]()
    {
        ui.openGLWidget->selectLine();
    });

    connect(ui.action_clear, &QAction::triggered, this, [=]()
    {
        ui.openGLWidget->clearAllLines();
    });

    connect(ui.action_undo, &QAction::triggered, this, [=]()
    {
        ui.openGLWidget->undoLastLine();
    });

    ui.menuBar->addAction(ui.action_drawLines);
    ui.menuBar->addAction(ui.action_selectLine);
    ui.menuBar->addAction(ui.action_clear);
    ui.menuBar->addAction(ui.action_undo);
}

MainWindow::~MainWindow()
{}

