#pragma once
#include <qopenglwidget.h>

#include <qopenglshaderprogram.h>
#include <QMouseEvent>

#include "model.h"
#include "camera.h"
#include "workPlane.h"
#include "viewCube.h"


class GLView : public QOpenGLWidget, QOpenGLFunctions_4_5_Core
{
	Q_OBJECT
public:
	explicit GLView(QWidget* parent = nullptr);
	~GLView();

protected:
	virtual void initializeGL();
	virtual void resizeGL(int w,int h);
	virtual void paintGL();
	virtual bool event(QEvent* e);

	void initWorkPlane();

private:
	void initShader(QOpenGLShaderProgram& shader, const QString& vertexFile, const QString& fragFile);

private:
	Model* m_model{ nullptr };
	Camera m_camera = Camera(this, QVector3D(0.0f, 0.0f, 5.0f));

	//mvp
	QMatrix4x4 m_modelMat;//ԶΪλ
	QMatrix4x4 m_viewMat;
	QMatrix4x4 m_projectionMat;

	//ɫ
	QOpenGLShaderProgram m_lightShader;
	QOpenGLShaderProgram m_viewCubeShader;

	//ƽ
	WorkPlane* m_workPlane{ nullptr };

	//ͼ
	ViewCube* m_viewCube{ nullptr };

	QMatrix4x4 m_modelCube;      
	QMatrix4x4 m_viewMatNoTrans;
	QMatrix4x4 m_projection4ViewCube;
	QMatrix4x4 m_finalProjection;

signals:

};