#version 450 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aColor;

out vec3 fragColor;
out vec2 screenPos;  // 输出屏幕坐标（用于渐变）

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;
uniform vec2 screenSize;  // 屏幕宽高

void main() {
    gl_Position = projection * view * model * vec4(aPos, 1.0);
    fragColor = aColor;
    // 计算屏幕坐标（标准化到0~1范围）
    screenPos = (gl_Position.xy / gl_Position.w + 1.0) * 0.5;
}