    #version 450 core
in vec3 fragColor;
in vec2 screenPos;  // 接收屏幕坐标
out vec4 FragColor;

// 渐变颜色参数（CAD风格深灰渐变）
vec3 topColor = vec3(0.25f, 0.25f, 0.25f);  // 顶部稍亮
vec3 bottomColor = vec3(0.15f, 0.15f, 0.15f);  // 底部稍暗

void main() {
    // 绘制模型时用原有颜色，否则用渐变色背景
    if (gl_FragCoord.z < 1.0) {  // 若该像素是模型（z值小于1）
        FragColor = vec4(fragColor, 1.0);
    } else {  // 否则是背景
        // 按Y坐标插值计算渐变颜色
        float t = screenPos.y;  // t=0是底部，t=1是顶部
        vec3 bgColor = mix(bottomColor, topColor, t);
        FragColor = vec4(bgColor, 1.0);
    }
}