#pragma once
#include <qopenglfunctions_4_5_core.h>
#include <qvector3d.h>

const float GRID_COLOR_R = 0.3f;
const float GRID_COLOR_G = 0.3f;
const float GRID_COLOR_B = 0.3f;

struct PlanePara
{
	QVector3D origin;        // ƽԭ
	QVector3D normal;        // ƽ淨
	QVector3D localX;        // ƽ汾X
	QVector3D localY;        // ƽ汾Y
	float halfLength;        // ƽ볤ԭ
	unsigned int gridCntPerEdge; // ÿԭ
	float offset;            // ƽƫԭ
};

class WorkPlane : public QOpenGLFunctions_4_5_Core
{
public:
	WorkPlane() {}
	~WorkPlane() {}

	void initPlane(const PlanePara& para)
	{
		initializeOpenGLFunctions();
		m_planePara = para;

		initLocalXY(m_planePara.normal, m_planePara.localX, m_planePara.localY);
		generateGridLines(m_planePara);
	}

	void drawPlane()
	{
		glBindVertexArray(m_vao);
		glDrawArrays(GL_LINES, 0, m_gridVertexCount);
		glBindVertexArray(0);
	}

private:
	void initLocalXY(const QVector3D& normal, QVector3D& localX, QVector3D& localY)
	{
		QVector3D yAxis(0, 1, 0);
		QVector3D xAxis(1, 0, 0);

		QVector3D ref = (QVector3D::crossProduct(normal, xAxis).length() < 1e-6) ? yAxis : xAxis;
		localX = QVector3D::crossProduct(normal, ref).normalized();
		localY = QVector3D::crossProduct(normal, localX).normalized();
	}

	void generateGridLines(const PlanePara& para)
	{
		std::vector<float> gridVertices;
		float step = (2.0f * para.halfLength) / para.gridCntPerEdge;

		QVector3D start, end;
		float offset;

		//ƽX
		for (int i = 0; i <= para.gridCntPerEdge; i++)
		{
			offset = -para.halfLength + i * step;
			start = para.origin - para.halfLength * para.localX + offset * para.localY;
			end = para.origin + para.halfLength * para.localX + offset * para.localY;

			start += para.offset * para.normal;
			end += para.offset * para.normal;

			gridVertices.insert(gridVertices.end(),
				{
					start.x(), start.y(), start.z(), GRID_COLOR_R, GRID_COLOR_G, GRID_COLOR_B,
					end.x(), end.y(), end.z(), GRID_COLOR_R, GRID_COLOR_G, GRID_COLOR_B,
				});
		}

		//ƽy
		for (int i = 0; i <= para.gridCntPerEdge; i++)
		{
			offset = -para.halfLength + i * step;
			start = para.origin - para.halfLength * para.localY + offset * para.localX;
			end = para.origin + para.halfLength * para.localY + offset * para.localX;

			start += para.offset * para.normal;
			end += para.offset * para.normal;

			gridVertices.insert(gridVertices.end(),
				{
					start.x(), start.y(), start.z(), GRID_COLOR_R, GRID_COLOR_G, GRID_COLOR_B,
					end.x(), end.y(), end.z(), GRID_COLOR_R, GRID_COLOR_G, GRID_COLOR_B,
				});
		}

		m_gridVertexCount = gridVertices.size() / 6;

		glGenVertexArrays(1, &m_vao);
		glGenBuffers(1, &m_vbo);

		glBindVertexArray(m_vao);
		glBindBuffer(GL_ARRAY_BUFFER, m_vbo);
		glBufferData(GL_ARRAY_BUFFER, gridVertices.size() * sizeof(float), gridVertices.data(), GL_STATIC_DRAW);

		glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 6 * sizeof(float), (void*)0);
		glEnableVertexAttribArray(0);
		glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 6 * sizeof(float), (void*)(3 * sizeof(float)));
		glEnableVertexAttribArray(1);

		glBindVertexArray(0);
	}

private:
	unsigned int m_vao, m_vbo;
	PlanePara m_planePara;
	int m_gridVertexCount;           // 񶥵
};