#include "model.h"
#define USE_VBO 0

Model::Model(QOpenGLFunctions_4_5_Core* openglFuncs) :
	m_glfunc(openglFuncs),
	m_vbo(QOpenGLBuffer::VertexBuffer),
	m_ebo(QOpenGLBuffer::IndexBuffer)
{
	// ʼm_vboΪ㻺壨VertexBuffer
	//m_vbo = QOpenGLBuffer(QOpenGLBuffer::VertexBuffer);

	// ʼm_eboΪ壨IndexBuffer
	//m_ebo = QOpenGLBuffer(QOpenGLBuffer::IndexBuffer);
}

Model::~Model()
{
	m_vao.destroy();
	m_vbo.destroy();
	m_ebo.destroy();
}

void Model::Draw(QOpenGLShaderProgram& shader)
{
	if (!m_vao.isCreated())
		m_vao.create();//ûдvaoһvao
	else
		m_vao.release();//Ѿڵvao
	QOpenGLVertexArrayObject::Binder vaoBinder(&m_vao);

	if (!m_vbo.isCreated())
		m_vbo.create();
	else
		m_vbo.release();

	if (!m_ebo.isCreated())
		m_ebo.create();
	else
		m_ebo.release();

	m_vbo.bind();
	m_vbo.allocate(vertices, sizeof(vertices));//൱glbufferdatacpuеݽgpuɫеaposgpuлȡ

	m_ebo.bind();
	m_ebo.allocate(indices, sizeof(indices));

	//ö
	m_glfunc->glEnableVertexAttribArray(0);//ɫеLocationӦ
	m_glfunc->glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 6 * sizeof(float), (void*)0);

	//öɫ
	m_glfunc->glEnableVertexAttribArray(1);
	m_glfunc->glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 6 * sizeof(float), (void*)(3 * sizeof(float)));

	//ɫȫֱ
	shader.setUniformValue("objectColor", 0.0f, 0.5f, 0.2f, 1.0f);

	if (USE_VBO)
	{
		int vertexCount = sizeof(vertices) / (6 * sizeof(float));
		m_glfunc->glDrawArrays(GL_TRIANGLES, 0, vertexCount);
	}
	else//USE_EBO
	{
		m_glfunc->glDrawElements(GL_TRIANGLES, sizeof(indices) / sizeof(indices[0]), GL_UNSIGNED_INT, 0);
	}
}


