#include "glview.h"
#include <QOpenglshader>

GLView::GLView(QWidget* parent)
{

}

void GLView::initializeGL()
{
	initializeOpenGLFunctions();
	initShader(m_shader);
	m_model = new Model(this);
}

void GLView::resizeGL(int w, int h)
{

}

void GLView::paintGL()
{
	glClearColor(0.2f, 0.3f, 0.3f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT);
	
	m_shader.bind();
	m_model->Draw(m_shader);
	m_shader.release();
}

bool GLView::initShader(QOpenGLShaderProgram& shader)
{
	bool result = false;
	result = shader.addShaderFromSourceFile(QOpenGLShader::Vertex, "./shader/1.model_loading.vert");
	if (!result)
	{
		qDebug() << shader.log();
		return result;
	}
	
	result = shader.addShaderFromSourceFile(QOpenGLShader::Fragment,"./shader/1.model_loading.frag");
	if (!result)
	{
		qDebug() << shader.log();
		return result;
	}

	result = shader.link();
	if (!result)
	{
		qDebug() << shader.log();
		return result;
	}

	return true;
}
